function [results,binresvect] = crossval2(training,auth_idx,k,fhandle,param,useIG,split,nfeat)
%Performs a k-fold crossvalidation on the training data, k must be an
%integer of size 2 or more, using the claasification method given in fhandle, handle must take same arguments as knnclassification.
binresvect=zeros(length(auth_idx),1);
if k==0
    k=length(auth_idx);
end
%keep 1 row for each author containing in order: TP TN FP FN
results = zeros(length(unique(auth_idx)),4);

%split the training set in k groups for crossvalidation
indices = crossvalind('kfold',size(training,1),k);
%do the big crossval loopy thing.
orgtraining=training;
for i=1:k
    testidx = (indices == i); trainidx = ~testidx;
    if useIG
        idx=Freqsort(orgtraining(trainidx,:),auth_idx(trainidx),split,nfeat);

        training=orgtraining(:,idx);
    end

    [t2,a2]=unskew(training(trainidx,:),auth_idx( trainidx));
    
    resC = fhandle(training(testidx,:),t2,a2,param);   
%now count results.
    binresvect(testidx)=resC; 

for j=1:size(results,1)

        %TP
    tmpidx=auth_idx(testidx)==j; %the ones that should be this author
    results(j,1) = results(j,1) + sum((resC==j) & tmpidx); %TP
    results(j,2) = results(j,2) + sum((resC~=j) & ~tmpidx); %TN
    results(j,3) = results(j,3) + sum((resC==j) & ~tmpidx); %FP
    results(j,4) = results(j,4) + sum((resC~=j) & tmpidx);  %FN  
    end
end
binresvect=(binresvect==auth_idx);

end